# Copyright 1999-2012 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: /usr/local/portage//sys-kernel/zen-sources/zen-sources-3.2.ebuild,v 1.1 2012/01/21 12:24:14 pacho Exp $

EAPI="2"
ETYPE="sources"

inherit kernel-2
detect_version
detect_arch

DESCRIPTION="TuxOnIce + Zen patchset sources"
HOMEPAGE="http://zen-kernel.org http://www.tuxonice.net"
IUSE="toi"

EPATCH_OPTS="-p1"

KV_FULL="zen-stable-${PV}"

UNIPATCH_STRICTORDER="yes"
KERNEL_URI="http://git.zen-kernel.org/zen-stable/snapshot/zen-stable-${PV}.tar.bz2"
SRC_URI="${KERNEL_URI}"

KEYWORDS="~amd64 ~x86"

RDEPEND="${RDEPEND}
	toi? (
	>=sys-apps/tuxonice-userui-1.0
	|| ( >=sys-power/hibernate-script-2.0 sys-power/pm-utils ) ) "

K_EXTRAELOG="If there are issues with this kernel, please direct any
queries to the tuxonice-users mailing list:
http://lists.tuxonice.net/mailman/listinfo/tuxonice-users/"
K_SECURITY_UNSUPPORTED="1"

pkg_setup(){
        ewarn
        ewarn "${PN} is *not* supported by the Gentoo Kernel Project in any way."
        ewarn "If you need support, please contact the Zen developers directly."
        ewarn "If you use the toi use flag tuxonice is patched into zen-sources."
        ewarn "In this case do not contact them. You are on your own."
        ewarn "Do *not* open bugs in Gentoo's bugzilla."
        ewarn "the ebuilds. Thank you."
        ewarn
        ebeep 8
        kernel-2_pkg_setup
}


src_unpack() {
    unpack ${A}
	mv 	zen-stable-${PV} linux-${PV}-zen
	cd linux-${PV}-zen
	if use toi
		then
		#	epatch "${DISTDIR}/current-tuxonice-for-${TUXONICE_TARGET}_${TUXONICE_SNAPSHOT}.patch.bz2"
		epatch "${FILESDIR}/tuxonice-3.2.1.patch.bz2" 
		fi
		}

pkg_postinst() {
	kernel-2_pkg_postinst
	einfo "For more info on this patchset, and how to report problems, see:"
	einfo "${HOMEPAGE}"
}
