##
## headtracking.nas
##
##  Nasal code for using an external head position and orientation tracker.
##
##  This file is licensed under the GPL license version 2 or later.
##    Copyright (C) 2007 - 2009  Anders Gidenstam

## Installation:
## - Put this file in ~/.fgfs/Nasal
## - Start FlightGear with the parameters
##    --generic=socket,in,<hz>,,<port>,udp,headtrack --prop:/sim/headtracking/enabled=1


##
# Headtracker view handler class.
# Use one instance per headtracked view.
#
var headtracker_view_handler = {
    new : func {
        return { parents: [headtracker_view_handler] };
    },
    init : func {
        if (contains(me, "enabled")) return;

        me.enabled = props.globals.getNode("/sim/headtracking/enabled", 1);
        me.ht_pos_offset =
            props.globals.getNode("/sim/headtracking/position", 1);
        me.ht_rot_offset =
            props.globals.getNode("/sim/headtracking/orientation", 1);

        # Low pass filters.
        me.hoffset_lowpass = aircraft.lowpass.new(0.1);
        me.poffset_lowpass = aircraft.lowpass.new(0.1);

        me.view = props.globals.getNode("/sim/current-view", 1);

#        print("headtracker_view_manager ... initialized.");
    },
    start : func {
    },
    stop : func {
    },
    reset : func {
        var heading = me.hoffset_lowpass.filter(0);
        var pitch   = me.poffset_lowpass.filter(0);

        me.view.getChild("goal-heading-offset-deg").setValue(heading);
        me.view.getChild("goal-pitch-offset-deg").setValue(pitch);
    },
    update : func {
        if (me.enabled.getValue()) {
            var heading =
                me.hoffset_lowpass.filter
                (1*asnum(me.ht_rot_offset.getChild("heading-deg").getValue()));
            var pitch   =
                me.poffset_lowpass.filter
                (-1.0*asnum(me.ht_rot_offset.getChild("pitch-deg").getValue()));
            var roll    =
                asnum(me.ht_rot_offset.getChild("roll-deg").getValue());

            var x = asnum(me.ht_pos_offset.getChild("x-offset-m").getValue());
            var y = asnum(me.ht_pos_offset.getChild("y-offset-m").getValue());
            var z = asnum(me.ht_pos_offset.getChild("z-offset-m").getValue());

            me.view.getChild("goal-heading-offset-deg").setValue(heading);
            me.view.getChild("goal-pitch-offset-deg").setValue(pitch);
            me.view.getChild("goal-roll-offset-deg").setValue(roll);

#            me.view.getChild("target-x-offset-m").setValue(x);
#            me.view.getChild("target-y-offset-m").setValue(y);
#            me.view.getChild("target-z-offset-m").setValue(z);
        }
#        print("Tracker position: (" ~
#              asnum(me.ht_pos_offset.getChild("x-offset-m").getValue()) ~" " ~
#              asnum(me.ht_pos_offset.getChild("y-offset-m").getValue()) ~" " ~
#              asnum(me.ht_pos_offset.getChild("z-offset-m").getValue()) ~")");
        return 0;
    }
};

var asnum = func(n) {
    if(typeof(n) == "scalar") {
        return num(n);
    } else {
        return 0;
    }
}

if (getprop("/sim/headtracking/enabled")) {
    if (view.indexof("Cockpit View") != nil)
        view.manager.register("Cockpit View", headtracker_view_handler);
    if (view.indexof("Pilot View") != nil)
        view.manager.register("Pilot View", headtracker_view_handler);
    if (view.indexof("Copilot View") != nil)
        view.manager.register("Copilot View", headtracker_view_handler);
}
