/*
 # (C) 2009-2010 Jürgen Löb
 #
 # This program is distributed in the hope that it will be useful,
 # but WITHOUT ANY WARRANTY; without even the implied warranty of
 # MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 # See the Attribution-NonCommercial-ShareAlike 3.0 Unported for more details.
 #
 */
#ifndef VR920TRACKINGMANIPULATOR_H_
#define VR920TRACKINGMANIPULATOR_H_

#pragma once

#include <osgGA/TrackballManipulator>
#include <osgGA/GUIEventAdapter>
#include <osgGA/GUIActionAdapter>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>

using namespace osgGA;

struct TrackingData {
	double viewmatrix[16];
	double yaw;
	double pitch;
	double roll;
};

const static unsigned char ttl = 3;
const static unsigned char one = 1;

class VR920TrackingManipulator: public osgGA::TrackballManipulator {

private:

	TrackingData trackingdata;

	struct ip_mreq command;
	char* multicastAddress;
	int socket_descriptor;
	socklen_t sin_len;
	struct sockaddr_in sin;
	int port;

	/*!
	 OSG-Variablen zur Einstellung der Kamera ????
	 */
	osg::Vec3d _eye;
	osg::Quat _rotation;
	osg::Matrixd _result;
	float _distance;
	osg::Matrixd zeromatrix;
	osg::Matrixd _baserot;
	double m[16];
	bool connected;

	int createMulticastSocket();

public:
	VR920TrackingManipulator();
	VR920TrackingManipulator(char* multicastAddress, int port);

	~VR920TrackingManipulator(void);

	virtual void init(const GUIEventAdapter&, GUIActionAdapter&);

	virtual void setByMatrix(const osg::Matrixd& matrix);

	/** set the position of the matrix manipulator using a 4x4 Matrix.*/
	//  virtual void setByInverseMatrix(const osg::Matrixd& matrix) { setByMatrix(osg::Matrixd::inverse(matrix)); };

	virtual void setByInverseMatrix(const osg::Matrixd& matrix);

	/** get the position of the manipulator as 4x4 Matrix.*/
	virtual osg::Matrixd getMatrix() const;

	/** get the position of the manipulator as a inverse matrix of the manipulator, typically used as a model view matrix.*/
	virtual osg::Matrixd getInverseMatrix() const;

	virtual bool calcMovement();

	bool handle(const osgGA::GUIEventAdapter& ea, osgGA::GUIActionAdapter& us);

	virtual void home(const GUIEventAdapter& ea, GUIActionAdapter& us);

	virtual void home(double /*currentTime*/);

	void computePosition(const osg::Vec3& eye, const osg::Vec3& center,
			const osg::Vec3& up);

protected:

};

#endif /*VR920TRACKINGMANIPULATOR_H_*/
