/*
 * (C) 2009-2010 Jürgen Löb
 #
 # This program is distributed in the hope that it will be useful,
 # but WITHOUT ANY WARRANTY; without even the implied warranty of
 # MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 # See the Attribution-NonCommercial-ShareAlike 3.0 Unported for more details.
 #
 */

#ifndef OSD_HPP_
#define OSD_HPP_

#include <string>
using std::string;
#include <osgText/Text>
#include <osg/Switch>
#include <osg/Geode>
#include <osg/Projection>
#include <osg/MatrixTransform>
#include <osg/Transform>
#include <osg/Timer>
#include <iostream>

class OSD: public osg::Switch {

	/*! \brief Constructor for osg internal smart pointers.
	 */
	/*! Does notzhing more than copying an existing ODETransform.*/
	OSD(const OSD& pat, const osg::CopyOp& copyop = osg::CopyOp::SHALLOW_COPY) :
		osg::Switch(pat, copyop) {
		//getSpace();
		//getWorld();
	}

	// META information for osg smart pointers
	META_Node(osg, OSD)
	;
public:

	OSD();

	~OSD() {
	}
	void updateTimer();
	void enable();
	void disable();
	void setText(const string& tex, float delay = 0);
	void setFont(const string& font);
	void setColor(osg::Vec4d color);
	void setPosition(osg::Vec3d position);
	void setTextSize(unsigned int size);

	string getText() const;

private:

	osg::Timer timer;

	osg::Timer_t start_tick;

	osg::Timer_t end_tick;

	osg::MatrixTransform * matrixTransform;

	osg::Projection * projectionMatrix;

	osg::Geode * textGeode;

	osgText::Text * text;

	float delay;

	class OSDNodeCallback: public osg::NodeCallback {
	public:
		virtual void operator()(osg::Node* node, osg::NodeVisitor* nv) {
			osg::ref_ptr<OSD> osd = dynamic_cast<OSD*> (node);
			if (osd) {
				osd->updateTimer();
			}
			traverse(node, nv);
		}
	};

};
#endif /*OSD_HPP_*/
