/*
 # (C) 2009-2010 Jürgen Löb
 #
 # This program is distributed in the hope that it will be useful,
 # but WITHOUT ANY WARRANTY; without even the implied warranty of
 # MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 # See the Attribution-NonCommercial-ShareAlike 3.0 Unported for more details.
 #
 */
#include "VR920TrackingManipulator.hpp"
#include "osd.hpp"
#include <iostream>
#include <stdlib.h>
#include <stdio.h>

extern osg::ref_ptr<OSD> osd;

VR920TrackingManipulator::VR920TrackingManipulator() :
	osgGA::TrackballManipulator() {
	std::cout << multicastAddress << std::endl;

}

VR920TrackingManipulator::VR920TrackingManipulator(char* multicastAddress,
		int port) :
	osgGA::TrackballManipulator() {
	this->multicastAddress = multicastAddress;
	this->port = port;
	std::cout << "receiving multicasts: " << multicastAddress << ":" << port
			<< std::endl;

}

VR920TrackingManipulator::~VR920TrackingManipulator() {
	if (setsockopt(socket_descriptor, IPPROTO_IP, IP_DROP_MEMBERSHIP, &command,
			sizeof(command)) < 0) {
		//perror ("setsockopt:IP_DROP_MEMBERSHIP");
	}
	close(socket_descriptor);

	//  _distance = 1.0f;
	connected = false;

	//osg::Matrixd zeroMatrix;
	double zero[16];
	for (int i = 0; i < 16; i++) {
		zero[i] = 0;
		if (i % 5 == 0) {
			zero[i] = 1;
		}
	}

	zeromatrix.set(zero);

}

int VR920TrackingManipulator::createMulticastSocket() {
	int loop = 1;
	struct sockaddr_in sin;

	memset(&sin, 0, sizeof(sin));
	sin.sin_family = AF_INET;
	sin.sin_addr.s_addr = htonl(INADDR_ANY);
	sin.sin_port = htons(port);
	if ((socket_descriptor = socket(PF_INET, SOCK_DGRAM, 0)) == -1) {
		perror("socket()");
		exit(EXIT_FAILURE);
	}

	/* Allow multiple processes to use the same port */
	loop = 1;
	if (setsockopt(socket_descriptor, SOL_SOCKET, SO_REUSEADDR, &loop,
			sizeof(loop)) < 0) {
		perror("setsockopt:SO_REUSEADDR");
		exit(EXIT_FAILURE);
	}

	if (bind(socket_descriptor, (struct sockaddr *) &sin, sizeof(sin)) < 0) {
		perror("bind");
		exit(EXIT_FAILURE);
	}
	/* allow multicast */
	loop = 1;
	if (setsockopt(socket_descriptor, IPPROTO_IP, IP_MULTICAST_LOOP, &loop,
			sizeof(loop)) < 0) {
		printf("setsockopt:IP_MULTICAST_LOOP");
		exit(EXIT_FAILURE);
	}
	/* join the multicast group: */
	command.imr_multiaddr.s_addr = inet_addr(multicastAddress);
	command.imr_interface.s_addr = htonl(INADDR_ANY);
	if (command.imr_multiaddr.s_addr == -1) {
		printf("%s is no multicast address\n", multicastAddress);
		exit(EXIT_FAILURE);
	}
	if (setsockopt(socket_descriptor, IPPROTO_IP, IP_ADD_MEMBERSHIP, &command,
			sizeof(command)) < 0) {
		printf("setsockopt:IP_ADD_MEMBERSHIP");
	}

	int flags = fcntl(socket_descriptor, F_GETFL);
	//flags |= O_NONBLOCK;
	fcntl(socket_descriptor, F_SETFL, O_NONBLOCK);
	//fcntl(socket_descriptor, F_SETFL, flags);

	return socket_descriptor;
}

bool VR920TrackingManipulator::handle(const osgGA::GUIEventAdapter& ea,
		osgGA::GUIActionAdapter& us) {
	if (!connected) {
		if (createMulticastSocket() == -1) {
			std::cerr << "Could not connect to daemon" << std::endl;
			return (1);
		}
		connected = true;
	}

	osg::Matrixd zero_matrix(m[0], m[1], m[2], m[3], m[4], m[5], m[6], m[7],
			m[8], m[9], m[10], m[11], m[12], m[13], m[14], m[15]);

	//if(vr920_getInvertedMatrix(m) <= 0) break;
	sin_len = sizeof(sin);
	/*if(recvfrom(socket_descriptor, &trackingdata, sizeof(TrackingData), 0,
	 (struct sockaddr *) &sin, &sin_len) == -1) return false;*/

	// discard all but the newest paket
	while (recvfrom(socket_descriptor, &trackingdata, sizeof(TrackingData), 0,
			(struct sockaddr *) &sin, &sin_len) != -1)
		;

	for (int i = 0; i < 16; i++)
		m[i] = trackingdata.viewmatrix[i];

	/*std::cout <<            m[0] <<":"<<m[1] <<":"<<m[2] <<":"<<m[3]<<std::endl<<
	 m[4] <<":"<<m[5] <<":"<<m[6] <<":"<<m[7]<<std::endl<<
	 m[8] <<":"<<m[9] <<":"<<m[10]<<":"<<m[11]<<std::endl<<
	 m[12]<<":"<<m[13]<<":"<<m[14]<<":"<<m[15]<<std::endl<<std::endl;

	 std::cout << "received data" << std::endl;*/
	osg::Matrixd rotation_matrix(m[0], m[1], m[2], m[3], m[4], m[5], m[6],
			m[7], m[8], m[9], m[10], m[11], m[12], m[13], m[14], m[15]);

	/*   std::cout <<            m[0] <<":"<<m[1] <<":"<<m[2] <<":"<<m[3]<<std::endl<<
	 m[4] <<":"<<m[5] <<":"<<m[6] <<":"<<m[7]<<std::endl<<
	 m[8] <<":"<<m[9] <<":"<<m[10]<<":"<<m[11]<<std::endl<<
	 m[12]<<":"<<m[13]<<":"<<m[14]<<":"<<m[15]<<std::endl<<std::endl; */
	rotation_matrix.set(m);
	//rotation_matrix=rotation_matrix*osg::Matrixd::identity().rotate(90.0f,osg::Vec3d(1,0,0));
	//rotation_matrix=rotation_matrix*osg::Matrixd::identity().rotate(180.0f,osg::Vec3d(0,0,1));

	osg::Matrix conv(-1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f,
			0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f);

	//rotation_matrix = rotation_matrix*conv;
	//rotation_matrix=osg::Matrixd::identity();
	//setByMatrix(rotation_matrix);
	//_result=osg::Matrixd::identity().translate(osg::Vec3(0.0f,0.0f,-_distance))*zero_matrix*zeromatrix*rotation_matrix;
	//setByMatrix(_result);

	_rotation = (_baserot * rotation_matrix * zeromatrix).getRotate();//.inverse();
	//setByMatrix(rotation_matrix*osg::Matrixd::translate(0.0,0.0,-_distance));
	//_rotation = _result.getRotate();//rotation_matrix.getRotate();//.inverse();
	//    osg::Vec3 rotatedOffset;
	//   _eye.set(_pos[0], _pos[1], _pos[2]);


	//  _camRot.makeIdentity();
	// _result.makeRotate(osg::DegreesToRadians(_rot[0]),osg::Vec3(1,0,0));
	//  _camRot=_result;
	//  _result.makeRotate(osg::DegreesToRadians(-_rot[2]),osg::Vec3(0,0,1));
	//  _camRot=_result*_camRot;
	//  _result.makeRotate(osg::DegreesToRadians(_rot[1]),osg::Vec3(0,1,0));
	//  _camRot=_result*_camRot;

	//rotatedOffset=_offset * _camRot;
	// _eye.set(_pos[0]-rotatedOffset[0], _pos[1]+rotatedOffset[1], _pos[2]-rotatedOffset[2]);
	// _camPos.makeTranslate(_eye);
	//std::cout << "eyex:" << _eye[0] << " eyey:" << _eye[1] << " eyez:" << _eye[2] <<std::endl;
	//std::cout << "posx:" << _pos[0] << " posy:" << _pos[1] << " posz:" << _pos[2] <<std::endl;
	//std::cout << "offx:" << rotatedOffset[0] << " offy:" << rotatedOffset[1] << " offz:" << rotatedOffset[2] <<std::endl;
	//std::cout << "rotx:" << _rot[0] << " roty:" << _rot[1] << " rotz:" << _rot[2] <<std::endl;
	// _result= _camRot * _camPos;
	//this->setByMatrix(_result);


	/*//_eye.set(_pos[0], _pos[1], _pos[2]);
	 //_camPos.makeTranslate(_eye);

	 _camRot.makeIdentity();
	 _result.makeRotate(osg::DegreesToRadians(-_rot[2]),osg::Vec3(0,0,1));
	 _camRot=_result;
	 _result.makeRotate(osg::DegreesToRadians(_rot[0]),osg::Vec3(1,0,0));
	 _camRot=_result*_camRot;
	 _result.makeRotate(osg::DegreesToRadians(_rot[1]),osg::Vec3(0,1,0));
	 _camRot=_result*_camRot;

	 _rotation=_camRot.getRotate();// _camRot*_camPos; // * _camPos;
	 rotatedOffset=_camRot*_offset;
	 _eye.set(_pos[0]+rotatedOffset[0], _pos[1]+rotatedOffset[1], _pos[2]+rotatedOffset[2]);
	 //this->setByMatrix(_result);
	 //_camPos.makeTranslate(_eye);
	 */
	if (ea.getKey() == 'z') {
		zeromatrix = osg::Matrixd::inverse(rotation_matrix);
		std::cout << "SET ZERO" << std::endl;
		osd->setText("Zero view set.", 5);
	}

	// us.requestRedraw();
	//usleep(1000);
	//vr920_disconnect();
	usleep(500);
	//  return true;
	//double m[16];
	switch (ea.getEventType()) {
	case (GUIEventAdapter::FRAME):
		if (_thrown) {
			if (calcMovement())
				us.requestRedraw();
		}
		return false;
	default:
		break;
	}

	switch (ea.getEventType()) {

	case (GUIEventAdapter::DRAG): {
		addMouseEvent(ea);
		if (calcMovement())
			us.requestRedraw();
		us.requestContinuousUpdate(false);
		_thrown = false;
		return true;
	}

	case (GUIEventAdapter::KEYDOWN):
		if (ea.getKey() == GUIEventAdapter::KEY_Space) {
			flushMouseEventStack();
			_thrown = false;
			home(ea, us);
			return true;
		}
		return false;

	default:
		return false;
	}

	if (ea.getHandled())
		return false;

}

bool VR920TrackingManipulator::calcMovement() {
	// return if less then two events have been added.
	if (_ga_t0.get() == NULL || _ga_t1.get() == NULL)
		return false;

	float dx = _ga_t0->getXnormalized() - _ga_t1->getXnormalized();
	float dy = _ga_t0->getYnormalized() - _ga_t1->getYnormalized();

	float distance = sqrtf(dx * dx + dy * dy);
	// return if movement is too fast, indicating an error in event values or change in screen.
	if (distance > 0.5) {
		return false;
	}

	// return if there is no movement.
	if (distance == 0.0f) {
		return false;
	}

	unsigned int buttonMask = _ga_t1->getButtonMask();
	if (buttonMask == GUIEventAdapter::MIDDLE_MOUSE_BUTTON || buttonMask
			== (GUIEventAdapter::LEFT_MOUSE_BUTTON
					| GUIEventAdapter::RIGHT_MOUSE_BUTTON)) {

		// pan model.

		float scale = -0.1f * _distance;

		//osg::Matrix rotation_matrix;
		//rotation_matrix.makeRotate(_rotation);

		osg::Vec3 dv(dx * scale, dy * scale, 0.0f);

		//_center += dv * rotation_matrix;
		_center += dv;
		return true;

	} else if (buttonMask == GUIEventAdapter::RIGHT_MOUSE_BUTTON) {

		// zoom model.

		float scale = 1.0f + dy * 0.3f;

		// notify(DEBUG_INFO) << "Pushing forward"<<std::endl;
		// push the camera forward.
		//float scale = -fd;

		//osg::Matrix rotation_matrix(_rotation);

		//osg::Vec3 dv = (osg::Vec3(0.0f, -1.0f, 0.0f) * rotation_matrix) * (dy* scale);
		osg::Vec3 dv = (osg::Vec3(0.0f, 0.0f, 1.0f)) * (dy * scale);

		_center += dv;

		return true;

	}

	return false;
}

void VR920TrackingManipulator::setByMatrix(const osg::Matrixd& matrix) {
	//   _eye = matrix.getTrans();
	//   _rotation = matrix.getRotate();
	//   _distance = 1.0f;
	//   _baserot = osg::Matrixd::identity().rotate(_rotation);
}

void VR920TrackingManipulator::setByInverseMatrix(const osg::Matrixd& matrix) {
	//   _eye = matrix.getTrans();
	//   _rotation = matrix.getRotate();
	//   _distance = 1.0f;
	//   _baserot = osg::Matrixd::identity().rotate(_rotation);
}

osg::Matrixd VR920TrackingManipulator::getMatrix() const {
	// return osg::Matrixd::rotate(_pitch,1.0,0.0,0.0)*osg::Matrixd::rotate(_rotation)*osg::Matrixd::translate(_eye);
	return osg::Matrixd::translate(-_center) * osg::Matrixd::rotate(_rotation)
			* osg::Matrixd::translate(_eye);
}

osg::Matrixd VR920TrackingManipulator::getInverseMatrix() const {
	// return osg::Matrixd::rotate(_pitch,1.0,0.0,0.0)*osg::Matrixd::rotate(_rotation)*osg::Matrixd::translate(_eye);
	return osg::Matrixd::inverse(osg::Matrixd::translate(-_center)
			* osg::Matrixd::rotate(_rotation) * osg::Matrixd::translate(_eye));
}

void VR920TrackingManipulator::init(const GUIEventAdapter&, GUIActionAdapter&) {

}

void VR920TrackingManipulator::home(double /*currentTime*/) {
	if (getAutoComputeHomePosition())
		computeHomePosition();
	computePosition(_homeEye, _homeCenter, _homeUp);
	_center = osg::Vec3f(0, 0, 0);
	//_center=_homeCenter;
	// _thrown = false;
}

void VR920TrackingManipulator::home(const GUIEventAdapter& ea,
		GUIActionAdapter& us) {
	home(ea.getTime());

	us.requestRedraw();
	us.requestContinuousUpdate(true);
	us.requestWarpPointer((ea.getXmin() + ea.getXmax()) / 2.0f, (ea.getYmin()
			+ ea.getYmax()) / 2.0f);
}

void VR920TrackingManipulator::computePosition(const osg::Vec3& eye,
		const osg::Vec3& center, const osg::Vec3& up) {

	osg::Vec3d lv = center - eye;

	osg::Vec3 f(lv);
	f.normalize();
	osg::Vec3 s(f ^ up);
	s.normalize();
	osg::Vec3 u(s ^ f);
	u.normalize();

	osg::Matrixd rotation_matrix(s[0], u[0], -f[0], 0.0f, s[1], u[1], -f[1],
			0.0f, s[2], u[2], -f[2], 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);

	_eye = eye;
	_distance = lv.length();
	_rotation = rotation_matrix.getRotate().inverse();
	_baserot = osg::Matrixd::identity().rotate(_rotation);
}
