/*
 # (C) 2009-2010 Jürgen Löb
 #
 # This program is distributed in the hope that it will be useful,
 # but WITHOUT ANY WARRANTY; without even the implied warranty of
 # MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 # See the Attribution-NonCommercial-ShareAlike 3.0 Unported for more details.
 #
 */

#include "osd.hpp"

OSD::OSD() :
	matrixTransform(new osg::MatrixTransform()), projectionMatrix(
			new osg::Projection), textGeode(new osg::Geode()), text(
			new osgText::Text()) {
	matrixTransform->setReferenceFrame(osg::Transform::ABSOLUTE_RF);

	matrixTransform->addChild(projectionMatrix);

	this->addChild(matrixTransform);

	projectionMatrix->setMatrix(osg::Matrix::ortho2D(0, 640, 0, 480));

	projectionMatrix->addChild(textGeode);

	textGeode->addDrawable(text);

	text->setAxisAlignment(osgText::Text::SCREEN);

	text->setText("Default Text");
	osgText::Font* arialFont = osgText::readFontFile("fonts/arial.ttf");
	text->setFont(arialFont);
	text->setFontResolution(50, 50);
	text->setBackdropType(osgText::Text::DROP_SHADOW_BOTTOM_RIGHT);
	text->setBackdropOffset(0.1f);
	this->setUpdateCallback(new OSDNodeCallback);
}

void OSD::updateTimer() {
	if (delay <= 0)
		return;
	osg::Timer_t end_tick = timer.tick();
	if (timer.delta_s(start_tick, end_tick) > delay) {
		//std::cout << timer.delta_s(start_tick, end_tick) << std::endl;
		this->setAllChildrenOff();
		delay = 0;
	}

}

void OSD::setText(const string& t, float delay) {
	this->delay = delay;
	text->setText(t);
	start_tick = timer.tick();
	this->setAllChildrenOn();
}

void OSD::setFont(const string& font) {
	text->setFont(font);
}

void OSD::setColor(osg::Vec4d color) {
	text->setColor(color);
}

void OSD::setPosition(osg::Vec3d position) {
	text->setPosition(position);
}

void OSD::setTextSize(unsigned int size) {
	text->setCharacterSize(size);
}

string OSD::getText() const {
	return text->getText().createUTF8EncodedString();
}
