#Copyright 1999-2008 Gentoo Foundation
#Distributed under the terms of the GNU General Public License v2
# $Header: $
 
inherit qt4
DESCRIPTION="glslDevil is a tool for debugging the OpenGL shader pipeline, supporting GLSL vertex and fragment programs plus the recent geometry shader extension"
HOMEPAGE="http://www.vis.uni-stuttgart.de/glsldevil/index.html"
SRC_URI="http://www.vis.uni-stuttgart.de/${PN}/${P}.tar.gz"
 
LICENSE="Proprietary"
SLOT="0"
KEYWORDS="amd64 ppc sparc x86"
IUSE=""
 
RDEPEND=">=x11-libs/qt-opengl-4.3.2"
DEPEND="${RDEPEND}"
S=${WORKDIR}/${P}

src_unpack() {
	unpack ${A}
	cd "${S}"
}
 
src_install() {
  local bits
  if use x86; then
    bits=32
  elif use amd64; then
    bits=64
  fi
 
  cd "release${bits}"
  dobin glsldb
  cd libs
  dodir "/usr/bin/libs"
  insinto "/usr/bin/libs"
  doins *
  cd "plugins${bits}"
  dodir "/usr/bin/libs/plugins${bits}"
  insinto "/usr/bin/libs/plugins${bits}"
  doins *
} 
