# Copyright 1999-2005 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: /cvs/underware/osg/OpenSceneGraph/gentoo/dev-cpp/openscenegraph/openscenegraph-1.0.0-r1.ebuild,v 1.2 2006/07/31 13:04:33 cpinson Exp $

inherit eutils
DESCRIPTION="osgOcean was developed as part of an EU funded research initiative called the VENUS project. The VENUS project aims at providing scientific methodologies and technological tools for the virtual exploration of deep underwater archaeology sites. "
HOMEPAGE="http://code.google.com/p/osgocean/"
MY_P="osgOcean-${PV}"
SRC_URI="http://osgocean.googlecode.com/files/osgOcean-Source-1.0.rar
	http://osgocean.googlecode.com/files/osgOcean-Resources-1.0.rar"
SLOT="0"
LICENSE="LGPL"
KEYWORDS="x86 amd64"
IUSE="openmp"

DEPEND="virtual/opengl 
     app-arch/unrar
     || ( >=media-gfx/openscenegraph-2.6 >=dev-games/openscenegraph-2.6 )
     dev-cpp/fftss
     sys-devel/gcc[openmp]"

S="${WORKDIR}/${MY_P}"

src_unpack() {
	unpack osgOcean-Source-${PV}.rar
	unpack osgOcean-Resources-${PV}.rar 
}

src_compile() {
    mv Resources/*  osgOcean/resources/

    CCACHE=$(echo $FEATURES | grep 'ccache' | sed 's/.*ccache.*/ccache/g')
    if use openmp
    then
    	cmake osgOcean -DCMAKE_INSTALL_PREFIX=/usr -DOPENTHREADS_LIBRARY_DEBUG=OPENTHREADS_LIBRARY -DCMAKE_C_FLAGS=-fopenmp -DCMAKE_CXX_FLAGS=-fopenmp
    else
	cmake osgOcean -DCMAKE_INSTALL_PREFIX=/usr -DOPENTHREADS_LIBRARY_DEBUG=OPENTHREADS_LIBRARY
    fi
    emake
}

src_install() {
	make DESTDIR=${D} install || die "einstall failed"

# this is very very dirty, but since lib shoud be in lib and both, binary and lib need the resource path...

	mkdir ${D}/usr/lib/
	mkdir ${D}/usr/share/
	mkdir ${D}/usr/share/OpenSceneGraph-Data-2.8.0
	cd ${D}
	mv  usr/bin/libosgOcean.so usr/lib/
	mv  usr/bin/resources ${D}${OSG_FILE_PATH}/
	mv  ${D}${OSG_FILE_PATH}/resources/shaders/* ${D}${OSG_FILE_PATH}/
	mv  ${D}${OSG_FILE_PATH}/resources/island/* ${D}${OSG_FILE_PATH}/
	
	insinto "/usr/lib/pkgconfig"
}

