/*
  This is a module which is used for resending packets with inverted src and dst.

  Based on code from: ip_nat_dumb.c,v 1.9 1999/08/20
  and various sources.

  Copyright (C) 2000 Emmanuel Roger <winfield@freegates.be>

  Changes:
	25 Aug 2001 Harald Welte <laforge@gnumonks.org>
		- decrement and check TTL if not called from FORWARD hook
	18 Jul 2003 Harald Welte <laforge@netfilter.org>
		- merge Patrick McHardy's mirror fixes from 2.4.22 to
		  2.6.0-test1
	19 Jul 2003 Harald Welte <laforge@netfilter.org>
		- merge Patrick McHardy's rp_filter fixes from 2.4.22 to
		  2.6.0-test1
	05 Feb 2008 Juergen Loeb <j.loeb@loeb-it.de>
		- fixes für 2.6.24
	05 Mai 2008 Juergen Loeb <j.loeb@loeb-it.de>
        	- fixes für 2.6.25
			
  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */
#include <linux/module.h>
#include <linux/skbuff.h>
#include <linux/ip.h>
#include <net/ip.h>
#include <net/icmp.h>
#include <linux/netfilter_ipv4/ip_tables.h>
#include <linux/netdevice.h>
#include <linux/route.h>
#include <net/route.h>

#include <linux/types.h>
#include <linux/ip.h>
#include <linux/timer.h>
#include <linux/module.h>
#include <linux/netfilter.h>
#include <linux/netdevice.h>
#include <linux/if.h>
#include <linux/inetdevice.h>
#include <net/protocol.h>
#include <net/checksum.h>
#include <linux/netfilter_ipv4.h>
//#include <linux/netfilter_ipv4/ip_nat_rule.h>

#ifndef NFC_ALTERED
#define NFC_ALTERED 0x8000
#endif


#if 0
#define DEBUGP printk
#else
#define DEBUGP(format, args...)
#endif

static int
mirror_check(const char *tablename,
	       const void *e,
	       const struct xt_target *target,
	       void *targinfo,
	       unsigned int targinfosize,
	       unsigned int hook_mask)
{

	return 1;
}
static inline struct rtable *route_mirror(struct sk_buff *skb, int local)
{
        struct iphdr *iph = ((struct iphdr *)skb_network_header(skb));
	struct dst_entry *odst;
	struct flowi fl = {};
	struct rtable *rt;

	if (local) {
		fl.nl_u.ip4_u.daddr = iph->saddr;
		fl.nl_u.ip4_u.saddr = iph->daddr;
		fl.nl_u.ip4_u.tos = RT_TOS(iph->tos);

		if (ip_route_output_key(&init_net,&rt, &fl) != 0)
			return NULL;
	} else {
		/* non-local src, find valid iif to satisfy
		 * rp-filter when calling ip_route_input(). */
		fl.nl_u.ip4_u.daddr = iph->daddr;
		if (ip_route_output_key(&init_net,&rt, &fl) != 0)
			return NULL;

		odst = skb->dst;
		if (ip_route_input(skb, iph->saddr, iph->daddr,
					RT_TOS(iph->tos), rt->u.dst.dev) != 0) {
			dst_release(&rt->u.dst);
			return NULL;
		}
		dst_release(&rt->u.dst);
		rt = (struct rtable *)skb->dst;
		skb->dst = odst;
	}

	if (rt->u.dst.error) {
		dst_release(&rt->u.dst);
		rt = NULL;
	}

	return rt;
}

static inline void ip_rewrite(struct sk_buff *skb)
{
	u32 odaddr, osaddr;

	odaddr = ((struct iphdr *)skb_network_header(skb))->saddr;
	osaddr = ((struct iphdr *)skb_network_header(skb))->daddr;

	// do we really need it? skb->nfcache |= NFC_ALTERED;

	/* Rewrite IP header */
	((struct iphdr *)skb_network_header(skb))->daddr = odaddr;
	((struct iphdr *)skb_network_header(skb))->saddr = osaddr;
}

/* Stolen from ip_finish_output2 */
static void ip_direct_send(struct sk_buff *skb)
{
	struct dst_entry *dst = skb->dst;
	
	if (dst->hh)
                neigh_hh_output(dst->hh, skb);
       		else if (dst->neighbour)
                	 dst->neighbour->output(skb);
}
static unsigned int ipt_mirror_target(struct sk_buff *pskb,
		const struct net_device *in,
		const struct net_device *out,
		unsigned int hooknum,
		const struct xt_target *target,
		const void *targinfo,
		void *userinfo)


{	
	struct rtable *rt;
	struct sk_buff *nskb;
	unsigned int hh_len;

	/* Make skb writable */
	if (!skb_make_writable(pskb, sizeof(struct iphdr)))
		return 0;

	/* If we are not at FORWARD hook (INPUT/PREROUTING),
	 * the TTL isn't decreased by the IP stack */
	if (hooknum != NF_INET_FORWARD) {
		if (((struct iphdr *)skb_network_header(pskb))->ttl <= 1) {
			/* this will traverse normal stack, and 
			 * thus call conntrack on the icmp packet */
			icmp_send(pskb, ICMP_TIME_EXCEEDED, 
				  ICMP_EXC_TTL, 0);
			return NF_DROP;
		}
		ip_decrease_ttl(((struct iphdr *)skb_network_header(pskb)));
	}

	if ((rt = route_mirror(pskb, hooknum == NF_INET_LOCAL_IN)) == NULL)
		return NF_DROP;

	hh_len = (rt->u.dst.dev->hard_header_len + 15) & ~15;

	/* Copy skb (even if skb is about to be dropped, we can't just
	 * clone it because there may be other things, such as tcpdump,
	 * interested in it). We also need to expand headroom in case
	 * hh_len of incoming interface < hh_len of outgoing interface */
	nskb = skb_copy_expand(pskb, hh_len, skb_tailroom(pskb), GFP_ATOMIC);
	if (nskb == NULL) {
		dst_release(&rt->u.dst);
		return NF_DROP;
	}

	dst_release(nskb->dst);
	nskb->dst = &rt->u.dst;

	ip_rewrite(nskb);
	/* Don't let conntrack code see this packet:
	 * it will think we are starting a new
	 * connection! --RR */
//       printk(KERN_ALERT "MIRROR to %u.%u.%u.%u:%u\n",NIPQUAD(((struct iphdr *)skb_network_header(nskb))->daddr),ntohs(nskb->h.th->source));
   


 	printk(KERN_ALERT "MIRROR to %u.%u.%u.%u:%u\n",NIPQUAD(((struct iphdr *)skb_network_header(nskb))->daddr),ntohs(((struct tcphdr *)(nskb->data + (((struct iphdr *)skb_network_header(nskb))->ihl << 2)))->dest));
	ip_direct_send(nskb);

	return NF_DROP;
}



static struct ipt_target mirror_reg = {
	.name		= "MIRROR",
	.family         = AF_INET,
	.target		= ipt_mirror_target,
	.targetsize	= 0,//sizeof(struct ip_nat_multi_range_compat),
	.table		= "filter",
	.hooks		= (1 << NF_INET_LOCAL_IN) | (1 << NF_INET_FORWARD) |
                          (1 << NF_INET_LOCAL_OUT),
	.checkentry	= mirror_check,
	.me		= THIS_MODULE,
};

static int __init ipt_mirror_init(void)
{
	return xt_register_target(&mirror_reg);
}

static void __exit ipt_mirror_fini(void)
{
	xt_unregister_target(&mirror_reg);
}

module_init(ipt_mirror_init);
module_exit(ipt_mirror_fini);
