#!/bin/bash

#    Copyright (C) 2009  main-host.de GmbH
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.

DRIVE=/dev/cdrom

if [ -n "$1" ]
then
ISO=$1
else
echo 1st parameter must be an ISO-Image!!!
exit -1
fi

if [ -n "$2" ]
then
DRIVE=$2
fi

echo ISO File: $ISO
echo Drive: $DRIVE

BLOCKS=$(( $(ls -l $ISO | awk '{ print $5 }') / 2048 ))
echo Blocks in ISO: $BLOCKS
#MD5ISO=test1
echo Reading iso...
MD5ISO=$(cat $ISO | pv -ps $(( 2048*$BLOCKS )) | md5sum)
echo MD5Sum of ISO $MD5ISO
#MD5DVD=test2
echo Reading from device...
MD5DVD=$(dd if=$DRIVE bs=2048 count=$BLOCKS |pv -ps $(( 2048*$BLOCKS )) | md5sum)
echo MD5Sum of DVD $MD5DVD


if [ "$MD5ISO" == "$MD5DVD" ]
then
  echo Success!!
  exit 0
else 
  echo Image and media differ!!!
  exit -1
fi

