/*
* (C) 2009 Jürgen Löb 
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
# See the Attribution-NonCommercial-ShareAlike 3.0 Unported for more details.
#
*/

#ifndef OSD_HPP_
#define OSD_HPP_


#include <string>
using std::string;
#include <osgText/Text>
#include <osg/Geode>
#include <osg/Projection>
#include <osg/MatrixTransform>
#include <osg/Transform>


class OSD{
public:

  OSD();
    
  ~OSD() {}
  void setText(const string& text);
  void setFont(const string& font);
  void setColor(osg::Vec4d color);
  void setPosition(osg::Vec3d position);
  void setTextSize(unsigned int size);
    
  osg::Group& getGroup() const;

  string getText() const;
    
private:

  osg::MatrixTransform * matrixTransform;
    
  osg::Projection * projectionMatrix;

  osg::Geode * textGeode;
    

  osgText::Text * text;
};

#endif /*OSD_HPP_*/
