/*
# (C) 2009 Jürgen Löb 
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
# See the Attribution-NonCommercial-ShareAlike 3.0 Unported for more details.
#
*/

#include "osd.hpp"

OSD::OSD():
    matrixTransform(new osg::MatrixTransform()),
    projectionMatrix(new osg::Projection),
    textGeode(new osg::Geode()),
    text(new osgText::Text())
{
  matrixTransform->setReferenceFrame(osg::Transform::ABSOLUTE_RF);
    
  matrixTransform->addChild(projectionMatrix);
     
    projectionMatrix->setMatrix(osg::Matrix::ortho2D(0,640,0,480));
    
    projectionMatrix->addChild(textGeode);

    textGeode->addDrawable(text);
    
    text->setAxisAlignment(osgText::Text::SCREEN);
    
    text->setText("Default Text");
    osgText::Font* arialFont = osgText::readFontFile("fonts/arial.ttf");
    text->setFont(arialFont);
    text->setFontResolution(50,50);
    
}

void OSD::
setText(const string& t){
    text->setText(t);
}

void OSD::setFont(const string& font){
    text->setFont(font);
}

void OSD::setColor(osg::Vec4d color){
    text->setColor(color);
}

void OSD::setPosition(osg::Vec3d position){
    text->setPosition(position);
}

void OSD::setTextSize(unsigned int size){
    text->setCharacterSize(size);
}

osg::Group& OSD::getGroup() const{
    return *matrixTransform;
}

string OSD::getText() const{
    return text->getText().createUTF8EncodedString();
}
